<?php 

// disable quick edit from posts list
function pcma_ecb_remove_bulk_quick_edit($actions) {
    unset($actions['inline']);
    return $actions;
}
add_filter('bulk_actions-pcma_email_campaigns', 'pcma_ecb_remove_bulk_quick_edit');

function pcma_ecb_remove_inline_quick_edit($actions, $post) { 
    if($post->post_type == 'pcma_email_campaigns') {
        unset($actions['inline hide-if-no-js']);
    }
    return $actions;
}
add_filter('post_row_actions', 'pcma_ecb_remove_inline_quick_edit', 10, 2);




// filter usable user categories for PvtCotent admins
function pcma_ecb_pc_admin_role_filter_usable_pc_cats($opts, $remove) {
    $editable_cats = pc_wpuc_static::get_wp_user_editable_pc_cats();
    
    if($editable_cats == 'any') {
        return $opts;    
    }
    
    foreach($opts['pc_cats']['opts'] as $key => $val) {
        if(!in_array($key, $editable_cats)) {
            unset($opts['pc_cats']['opts'][$key]);    
        }
    }
    
    return $opts;
}
add_filter('pc_user_cat_dd_opts', 'pcma_ecb_pc_admin_role_filter_usable_pc_cats', 100, 2);





// metaboxes register
function pcma_ecb_register_metaboxes() {
    add_meta_box('pcma_ecb_template', __("E-mail template", PCMA_ML), 'pcma_ecb_template', 'pcma_email_campaigns', 'side', 'default');
    add_meta_box('pcma_ecb_receivers_counter', __("Receivers counter", PCMA_ML), 'pcma_ecb_receivers_counter', 'pcma_email_campaigns', 'side', 'low');
	add_meta_box('pcma_ecb_js_tricks_n_notes', __("Title and text placholders", PCMA_ML), 'pcma_ecb_js_tricks_n_notes', 'pcma_email_campaigns', 'side', 'low');
    
    add_meta_box('pcma_ecb_attachments', __('E-mail attachments', PCMA_ML) .' <span class="pcma_ecb_add_attach_btn add-new-h2">Add</span>', 'pcma_ecb_attachments', 'pcma_email_campaigns', 'normal', 'default');
	add_meta_box('pcma_ecb_receivers', __('Receivers', PCMA_ML), 'pcma_ecb_receivers', 'pcma_email_campaigns', 'normal', 'default');
}
add_action('admin_init', 'pcma_ecb_register_metaboxes');





// e-mail template
function pcma_ecb_template() {
    global $post; 
    dike_lc('lcweb', PCMA_DIKE_SLUG, true);
    
    $template = get_post_meta($post->ID, 'pcma_ecb_template', true);
    $disabled = (pcma_email_campaigns::campaign_can_be_edited($post->ID, $post->status)) ? '' : 'disabled';
    ?>
    
    <select name="pcma_ecb_template" class="pcma_lc_select" autocomplete="off" <?php echo $disabled ?>>
        <?php
        foreach(pcma_get_mail_templates() as $tpl_id => $tpl_name) {
            echo '<option value="'. (int)$tpl_id .'" '. selected($template, $tpl_id, false) .'>'. esc_html($tpl_name) .'</option>';	
        }
        ?>
    </select>
    <?php
}





// JS tricks to customize interface + side notes and allowed variables
function pcma_ecb_js_tricks_n_notes() {
    global $post;
    $outgoung_mail_limit = (int)get_option('pcma_bulk_mail_limit_num');
    
    $assoc = array(
        'title'     => 'pcma_ecb_title',
        'done'      => 'pcma_email_campaign_done',
        'paused'    => 'pcma_email_campaign_paused',
        
        'receivers'         => 'pcma_ecb_receivers', // array of user IDs
        'extra_user_ids'    => 'pcma_ecb_extra_user_ids', // array of extra user IDs
        'extra_emails'      => 'pcma_ecb_extra_emails', // array of extra e-mails

        'start_date'=> 'pcma_ecb_start_time', // datetime of when campaign started
        'processed' => 'pcma_ecb_receivers_processed', // array (user_id (or extra_email) => timestamp) of processed receivers
        'failed'    => 'pcma_ecb_receivers_failed', // array (user_id (or extra_email) => reason) of failed submissions
    );
    $metas = pcma_email_campaigns::get_campaign_metas($post->ID, $assoc);
    ?>

    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        <?php if(!$outgoung_mail_limit) : ?>
        alert(`<?php _e('Please set carefully the "Outgoing bulk e-mails limit" value to use campaigns', PCMA_ML) ?>`);
        window.location.href = `<?php echo admin_url('admin.php?page=pcma_settings') ?>`;
        return false;
        <?php endif; ?>
        
        
        <?php if($metas['title']) : ?>
            // "clone campaign" button
            if(document.querySelector('.page-title-action')) {    
                document.querySelector('.page-title-action').insertAdjacentHTML('afterend', ` <a href="javascript:void(0)" class="page-title-action pcma_ecb_clone_cmp" data-cmp-id="<?php echo $post->ID ?>"><?php esc_attr_e('Clone Campaign', PCMA_ML) ?></a>`);
            }

            <?php pcma_email_campaigns::campaign_clone_js_code() ?>
        <?php endif; ?>
        
        
        
        // post title management
        document.getElementById('title').setAttribute('placeholder', `<?php esc_attr_e('Internal campaign name', PCMA_ML) ?>`);
        
        setTimeout(function() {
            const email_title_disabled = (window.pcma_ecb_can_be_edited) ? '' : 'disabled';
            if(email_title_disabled) {
                document.getElementById('title').disabled = true;        
            }
            
            const email_title_input = `
            <hr class="pcma_ecb_title_hr" />
            <input type="text" name="pcma_ecb_title" size="30" value="<?php echo esc_attr($metas['title']) ?>" placeholder="<?php esc_attr_e('E-mail title', PCMA_ML) ?>" spellcheck="true" autocomplete="off" ${ email_title_disabled } />`;

            document.getElementById('title').insertAdjacentHTML('afterend', email_title_input);
            
        }, 5); // wait for global vars to be spread

        
        // setup emoji picker for title
        $(document).ready(function() {
            if(window.pcma_ecb_can_be_edited) {
                new lc_emoji_picker('input[name="pcma_ecb_title"]', { 
                    trigger_position : {
                        top : '6px',
                        right: '8px',
                    },
                    trigger_size : {
                        width : '22px',
                        height: '22px',
                    },
                    labels : [ 
                        `<?php esc_attr_e('insert emoji', PCMA_ML) ?>`,
                        `<?php esc_attr_e('search emoji', PCMA_ML) ?>`,
                        `<?php esc_attr_e('.. no results ..', PCMA_ML) ?>`,
                    ],
                    target_r_padding    : 28, 
                    emoji_json_url      : '<?php echo PCMA_URL ?>/js/lc-emoji-picker/emoji-list.min.json',
                });
            }
        });
        
        
        // hook into wditor media management - allow image only!
        $(document).on("DOMNodeInserted", function(){
            if(!$('.media-frame-menu').length) {
                return false;    
            }
            
            $('.media-frame-menu-heading, .media-frame-menu').remove();
            $('#media-frame-title, .media-frame-router, .media-frame-content, .media-frame-toolbar').css('left', 0);
            
            if($('#media-attachment-filters option[value="image"]').length) {
                $('#media-attachment-filters option[value="image"]')[0].selected = true;
                $('#media-attachment-filters').trigger('change');
            }
        });
        
        
        // tinymce preview + demo sending and emoji 
        $(document).ready(function() {
            window.pcma_setup_tinymce_emoji_n_preview(false, 'pcma_ecb_title', 'pcma_ecb_template');
            
            if(!window.pcma_ecb_can_be_edited) {
                setTimeout(function() {
                    $('.pcma-tinymce-preview-tab').trigger('click');
                    $('#content-tmce, #content-html, #insert-media-button').css('visibility', 'hidden');
                }, 100);
            }
        });
        
        
        // schedule box
        const set_datetime_label = function() {
            document.getElementById('timestamp').innerHTML = `<?php esc_attr_e('Scheduled date and time', PCMA_ML) ?>`;   
        };
        set_datetime_label();
        
        document.querySelector('#submitdiv h2.hndle').innerText = `<?php esc_attr_e('Schedule', PCMA_ML) ?>`;
        document.getElementById('publish').value = `<?php esc_attr_e('Schedule', PCMA_ML) ?>`;
        
        $(document).on('click', '.save-post-status, .cancel-post-status', function() {
            setTimeout(function() {
                if($('#post_status').val() == 'publish') {
                    publish_label_to_scheduled();
                }
                set_datetime_label();
            }, 1);        
        });
        
        
        // manage date/time fields
        let time_fields_html = {};
        
        ['hh', 'mn'].some(function(v) {
            const $field = document.querySelector('input[name="'+ v +'"]');
            
            const atts = {
                type : 'number',
                step : 1,
                min  : 0,
                max  : (v == 'hh') ? 23 : 59,
                required : 'required',
            };
            for(var key in atts) {
                let val = (v == 'mn' && key == 'step') ? 5 : atts[key]; // minutes field - step every 5

                $field.setAttribute(key, val);
                time_fields_html[v] = $field.outerHTML;
            }
            
            $field.remove();
        });
        
        const pcma_date = document.getElementById('aa').value +'-'+ document.getElementById('mm').value +'-'+ document.getElementById('jj').value;
              
        let datetime_div = `
        <fieldset id="pcma_ecb_timestampdiv">
            <input type="date" name="pcma_ecb_date" value="${ pcma_date }" min="<?php echo date_i18n('Y-m-d') ?>" onchange="window.pcma_ecb_set_date(event);" data-timezone="<?php echo esc_attr(wp_timezone_string()) ?>" required />
            <?php esc_attr_e('at') ?>
            ${ time_fields_html.hh }:${ time_fields_html.mn }
        </fieldset>
        <a href="javascript:void(0)" class="pcma_ecb_set_current_datetime"><?php esc_attr_e('Use current date', PCMA_ML) ?></a>`;
        
        document.getElementById('timestampdiv').insertAdjacentHTML('beforebegin', datetime_div);
        
        <?php if(empty($metas['title'])) : ?>
        document.querySelector('input[name="mn"]').value = '0';
        <?php endif; ?>
        
        
        // set datetime as "now" (considering the 5 minutes span)
        $(document).on('click', '.pcma_ecb_set_current_datetime', function() {
            
            const fivemins  = new Date(),
                  d         = new Date(fivemins.getTime() + 5 * 60000).toLocaleString("en-GB", {timeZone: "<?php echo wp_timezone_string() ?>"}),
                  d_arr     = d.split(', '),
                  date_arr  = d_arr[0].split('/').reverse(),
                  time_arr  = d_arr[1].split(':');
            
            const new_date  = date_arr.join('-'),
                  new_hh    = time_arr[0];
            
            let new_mn = parseInt(time_arr[1], 10),
                multip = Math.ceil( new_mn / 5 ) - 1;
            
            if(multip < 0) {
                multip = 0;    
            }
            
            $('input[name="pcma_ecb_date"]').val(new_date).trigger('change');
            $('#hh').val(new_hh);
            $('#mn').val(multip * 5);
        })
        
        
        
        // track date input change and reflect it on WP fields
        window.pcma_ecb_set_date = function(e) {
            const date_array = e.target.value.split('-');
            
            document.getElementById('jj').value = date_array[2];
            document.getElementById('aa').value = date_array[0];
            
            document.querySelectorAll('#mm option').forEach(function($opt) {
                $opt.selected = ($opt.getAttribute('value') == date_array[1]) ? true : false;
            });
        };
        
        
        // keep datetime label on submit
        document.getElementById('post').addEventListener('submit', function(e) {
            setTimeout(function() {
                set_datetime_label();
            }, 1);
        });
        
        
        // "view details" button
        $(document).on('click', '.pcma_ecb_view_progress_details', function(e) {
            lc_wp_popup_message('modal', $('.pcma_ecb_progress_details').html());
            $('.lcwpm_modal').addClass('pcma_ecb_rlt_modal pcma_ecb_pd_modal');            
        });
        
        
        const $submitbox = document.getElementById('minor-publishing');
        
        <?php 
        // if publication date is passed, turn "published" into "scheduled"
        if($post->post_status == 'publish') :
        ?>
        const publish_label_to_scheduled = function() {
            document.getElementById('post-status-display').innerText =`<?php esc_attr_e('Scheduled', PCMA_ML) ?>`;
            document.querySelector('#post_status option[value="publish"]').innerText = `<?php esc_attr_e('Scheduled', PCMA_ML) ?>`;
        };
        publish_label_to_scheduled();
        <?php
        endif;
        
        
        // operations in case of campaign already started
        if(in_array($post->post_status, array('publish', 'future'))) :
            $next_scheduled_sending_time = wp_next_scheduled('pcma_process_campaigns'); 
            $next_scheduled_sending = get_date_from_gmt(date('Y-m-d H:i:s', $next_scheduled_sending_time), 'H:i');
            
            $can_send_emails = pcma_email_campaigns::can_send_emails(); 
            $esipp_warning = pcma_email_campaigns::get_esipp_warning();        
    
            if($esipp_warning) {
                pcma_email_campaigns::sent_emails_counter_reset_js_code();    
            }
    
            if(!$metas['done']) :
               if(!pcma_email_campaigns::can_send_emails()) :
                ?>
                    $submitbox.insertAdjacentHTML('beforebegin', `
                    <div class="pcma_ecb_sending_banner pcma_ecb_error">
                        <?php echo $esipp_warning ?>
                    </div>`);    
        
                <?php elseif($esipp_warning) : ?>
                    
                    $submitbox.insertAdjacentHTML('beforebegin', `
                    <div class="pcma_ecb_sending_banner pcma_ecb_in_prog">
                        <?php echo $esipp_warning ?>
                    </div>`);
                
                <?php
                endif;
            endif;
    
    
            if($metas['done']) : 
                $overall_receivers = pcma_email_campaigns::overall_receivers($metas['receivers'], $metas['extra_user_ids'], $metas['extra_emails']);
                $tot_receivers = count($overall_receivers);
    
                $last_processed_gmt = date('Y-m-d H:i:s', end($metas['processed']));
                $last_processed_date = get_date_from_gmt($last_processed_gmt, 'Y/m/d') .' '. __('at') .' '. get_date_from_gmt($last_processed_gmt, 'H:i');
            ?>        
                const failed = `<?php echo (count($metas['failed'])) ? ' ('. count($metas['failed']) .' '. __('failed', PCMA_ML) .')' : '' ?>`;
        
                $submitbox.insertAdjacentHTML('beforebegin', `
                    <div class="pcma_ecb_sending_banner pcma_ecb_done">
                        <h4><?php esc_attr_e('Campaign completed!', PCMA_ML) ?></h4>                    
                        <ul>
                            <li><?php echo __("Last e-mail sent", PCMA_ML) .' '. $last_processed_date ?></li>
                            <li><?php echo number_format_i18n($tot_receivers) .' '. __("receiver(s) processed", PCMA_ML) ?></li>

                            <?php 
                            if(!empty($metas['failed'])) {
                                echo '<li>'. number_format_i18n(count($metas['failed'])) .' '. __("failed submission(s)", PCMA_ML) .'</li>';    
                            }
                            ?>
                        </ul>

                        <input type="button" class="button-secondary pcma_ecb_view_progress_details" value="<?php esc_attr_e("view details", PCMA_ML) ?>" />
                        <?php echo pcma_email_campaigns::progress_details_table($overall_receivers, $metas['processed'], $metas['failed']) ?>
                    </div>`);

                document.getElementById('pcma_ecb_timestampdiv').setAttribute('disabled', 'disabled');

                document.querySelectorAll('#publish, .misc-pub-post-status').forEach(function($el) {
                    $el.remove();   
                });
        
                // prevent post form submission
                document.getElementById('post').addEventListener("submit", function(e) {
                    e.preventDefault();
                    return false;
                }, true);
        
        
            <?php 
            elseif(!$metas['done'] && !empty($metas['start_date'])) : 
                $overall_receivers = pcma_email_campaigns::overall_receivers($metas['receivers'], $metas['extra_user_ids'], $metas['extra_emails']);
                $tot_receivers = count($overall_receivers);
            ?>
                
                $submitbox.insertAdjacentHTML('beforebegin', `
                    <div class="pcma_ecb_sending_banner pcma_ecb_in_prog">
                        <h4><?php ($metas['paused']) ? _e("Campaign paused!", PCMA_ML) : _e("Campaign in progress!", PCMA_ML) ?></h4>                    
                        <ul>
                            <li><?php echo number_format_i18n(count($metas['processed'])) .' '. __('of') .' '. number_format_i18n($tot_receivers) .' '. __("receiver(s) processed", PCMA_ML) ?></li>

                            <?php 
                            if(!empty($metas['failed'])) {
                                echo '<li>'. number_format_i18n(count($metas['failed'])) .' '. __("failed submission(s)", PCMA_ML) .'</li>';    
                            }
                                                        
                            if(!$metas['paused'] && $can_send_emails) {
                                echo '<li>'. __("Next scheduled sending at", PCMA_ML) .' '. $next_scheduled_sending .'</li>';    
                            }
                            ?>
                        </ul>

                        <input type="button" class="button-secondary pcma_ecb_view_progress_details" value="<?php esc_attr_e("view details", PCMA_ML) ?>" />
                        <?php echo pcma_email_campaigns::progress_details_table($overall_receivers, $metas['processed'], $metas['failed']) ?>
                    </div>`);

        
                // prevent update
                document.getElementById('pcma_ecb_timestampdiv').setAttribute('disabled', 'disabled');
                document.getElementById('misc-publishing-actions').remove();
                document.getElementById('publish').remove();   

                document.getElementById('post').addEventListener("submit", function(e) {
                    e.preventDefault();
                    return false;
                }, true); 
        

                // pause/resume button     
                document.querySelector('#publishing-action').insertAdjacentHTML('beforeend', `
                    <input type="button" class="button-primary pcma_ecb_change_cmp_status pcma_ecb_<?php echo ($metas['paused']) ? 'resume' : 'pause' ?>_cmp"
                        value="<?php ($metas['paused']) ? esc_attr_e('Resume campaign', PCMA_ML) : esc_attr_e('Pause campaign', PCMA_ML) ?>" />`);

        
                $(document).on('click', '.pcma_ecb_change_cmp_status', function(e) {
                    const $btn = $('.pcma_ecb_change_cmp_status'),
                          new_status = ($btn.hasClass('pcma_ecb_pause_cmp')) ? 'pause' : 'resume';
                    
                    $btn.hide();
                    $btn.after('<div class="pcma_ecb_ccs_spinner pc_spinner pc_spinner_inline"></div>');
                    
                    let data = {
                        action      : 'pcma_ecb_change_og_status',
                        new_status  : new_status,
                        campaign_id : window.pcma_ecb_campaign_id,
                        nonce       : window.pcma_ecb_nonce
                    };
                    $.post(ajaxurl, data, function(response) {
                               
                        if(response.trim() != 'success') {
                            lc_wp_popup_message('error', response);	
                            
                            $btn.show();
                            $('.pcma_ecb_ccs_spinner').remove();
                            
                            return false;
                        }

                        window.location.reload();
                    })
                    .fail(function(e) {
                        if(e.status) {
                            console.error(e);
                            lc_wp_popup_message('error', "<?php esc_attr_e('Error changing campaign status', PCMA_ML) ?>");	
                            
                            $btn.show();
                            $('.pcma_ecb_ccs_spinner').remove();
                        }    
                    });
                });
                    
        
        
            <?php else : ?>
                
                $submitbox.insertAdjacentHTML('beforebegin', `
                    <div class="pcma_ecb_sending_banner pcma_ecb_ready">
                        <h4><?php echo __("Campaign is ready to be processed!", PCMA_ML) ?></h4>
                        
                        <?php
                        if(strtotime($post->post_date_gmt) - (int)$next_scheduled_sending_time <= (60 * 4) && $can_send_emails) {
                            echo '
                            <span>'. __("Next scheduled sending at", PCMA_ML) .' '. $next_scheduled_sending .'</span>'; 
                        }
                        ?>
                    </div>`);
            <?php 
            endif;
        endif; /* if post has been saved */ 
        ?>
        
    })(jQuery);    
    </script>


    <table class="pcma_ecb_legend_table">  
      <tr>
        <td>%SITE-TITLE%</td>
        <td><span class="info"><?php _e("Website title specified in the WP settings", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%YEAR%</td>
        <td><span class="info"><?php _e("Current year in YYYY format", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%NAME%</td>
        <td><span class="info"><?php _e("User's Name", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%SURNAME%</td>
        <td><span class="info"><?php _e("User's Surname", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%USERNAME%</td>
        <td><span class="info"><?php _e("User's Username", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%MAIL%</td>
        <td><span class="info"><?php _e("User's E-mail", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%TEL%</td>
        <td><span class="info"><?php _e("User's Telephone", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td>%PC-CAT%</td>
        <td><span class="info"><?php _e("User Categories (comma split)", PCMA_ML); ?></span></td>
      </tr>
      <tr>
        <td colspan="2" class="pcma_legend_table_note"><?php _e('Remember you can use <a href="http://www.lcweb.it/privatecontent/user-data-add-on" target="_blank">User Data add-on</a> shortcode to insert custom fields into the mail text', PCMA_ML) ?></td>
      </tr>
    </table>
    <?php
}




// retrievers list in lightbox - side button box
function pcma_ecb_receivers_counter() {
    global $post;
    
    if(!pcma_email_campaigns::campaign_can_be_edited($post->ID, $post->status)) {
        echo '<style>#pcma_ecb_receivers_counter {display: none;}</style>';
        return true;
    }
    else {
    ?>
        <div class="pcma_ecb_rc_wrap pc_spinner"></div>

        <button type="button" class="pcma_ecb_list_pc_receivers button-secondary pc_displaynone">
            <span class="dashicons dashicons-groups"></span>
            <?php esc_html_e('List PrivateContent receivers', PCMA_ML) ?>
        </button>
    <?php 
    } 
    ?>

    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        const $wrap = $('.pcma_ecb_rc_wrap'),
              $list_users_btn = $('.pcma_ecb_list_pc_receivers');
        
        let curr_receivers_data,
            receivers_obj,
            ajax;
        
        
        // get receivers list and publish the result on screen
        const get_receivers = function() {
            const new_data = $('#pcma_ecb_receivers').find('input, select, textarea').serialize();
            
            if(new_data == curr_receivers_data) {
                return true;    
            }
            curr_receivers_data = new_data;
            
            $wrap.empty().addClass('pc_spinner');
            $list_users_btn.addClass('pc_displaynone');
            
            // get values
            let targeted_pc_cats        = $('select[name="pcma_ecb_include_pc_cats[]"]').val(),
                extra_user_ids_count    = $('#pcma_ecb_eui_list li').length,
                extra_receivers_count   = get_extra_mail_count();
            
            if(ajax) {
                ajax.abort();    
            }
            
            // no user cats - count only specific receivers
            if(!targeted_pc_cats.length) {
                $wrap.empty().removeClass('pc_spinner');
                
                if(!extra_user_ids_count && !extra_receivers_count) {
                    $wrap.html('<h3><span class="dashicons dashicons-groups"></span><?php esc_attr_e('no receivers selected', PCMA_ML) ?><h3>');
                }
                else {
                    const tot_receivers = extra_user_ids_count + extra_receivers_count;
                    let counter_txt = '<h3><span class="dashicons dashicons-groups"></span>'+ tot_receivers.toLocaleString(navigator.language) +' <?php esc_attr_e('receiver(s)', PCMA_ML) ?><h3>';
                    
                    if(extra_user_ids_count) {
                        counter_txt += '<h4>'+ extra_user_ids_count.toLocaleString(navigator.language) +' <?php esc_attr_e('targeted user(s)', PCMA_ML) ?></h4>';         
                    }
                    if(extra_receivers_count) {
                        counter_txt += '<h4>'+ extra_receivers_count.toLocaleString(navigator.language) +' <?php esc_attr_e('extra e-mail(s)', PCMA_ML) ?></h4>';         
                    }
                    
                    $('.pcma_ecb_rc_wrap').html(counter_txt);
                }
                
                return true;
            }
            
            // ajax
            let data = 'action=pcma_ecb_list_receivers&nonce='+ window.pcma_ecb_nonce +'&' + new_data;

            ajax = $.post(ajaxurl, data, function(response) {
                try {
                    const resp = JSON.parse(response);

                    if(resp.status != 'success') {
                        lc_wp_popup_message('error', resp.mess);	
                        return false;
                    }
                    receivers_obj = resp.users;

                    const receivers     = resp.users.length,
                          tot_receivers = receivers + extra_user_ids_count + extra_receivers_count;

                    
                    let counter_txt = '<h3><span class="dashicons dashicons-groups"></span>'+ tot_receivers.toLocaleString(navigator.language) +' <?php esc_attr_e('receiver(s)', PCMA_ML) ?><h3>';
                    
                    if(receivers) {
                        counter_txt += '<h4>'+ receivers.toLocaleString(navigator.language) +' <?php esc_attr_e('matching user(s)', PCMA_ML) ?> (<a href="javascript:void(0)" id="pcma_ecb_show_receivers_list"><?php esc_attr_e('show list', PCMA_ML) ?></a>)</h4>';         
                    }
                    if(extra_user_ids_count) {
                        counter_txt += '<h4>'+ extra_user_ids_count.toLocaleString(navigator.language) +' <?php esc_attr_e('targeted user(s)', PCMA_ML) ?></h4>';         
                    }
                    if(extra_receivers_count) {
                        counter_txt += '<h4>'+ extra_receivers_count.toLocaleString(navigator.language) +' <?php esc_attr_e('extra e-mail(s)', PCMA_ML) ?></h4>';         
                    }
                    
                    $('.pcma_ecb_rc_wrap').html(counter_txt);
                }
                catch(e) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error generating receivers list', PCMA_ML) ?>");

                    $wrap.empty().removeClass('pc_spinner');
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error generating receivers list', PCMA_ML) ?>");	
                }    
            })
            .always(function() {
                $wrap.removeClass('pc_spinner');
            });
            
        };
        
        
        $(document).ready(function() {
            setInterval(get_receivers, 5000);        
        });
        
        
        
        
        // get extra e-mails counter
        const get_extra_mail_count = function() {
            let extra_receivers = $('textarea[name="pcma_ecb_extra_emails"]').val().trim();
            
            if(extra_receivers) {
                extra_receivers = extra_receivers.split(/\r?\n/);
                
                $.each(extra_receivers, function(i, v) {
                    if(!v.trim()) {
                        extra_receivers.splice(i, 1);
                    }
                });
                
                return extra_receivers.length;
            }
            else {
                return 0;    
            }   
        };
        
        
        
        // show receivers list 
        $(document).on('click', '#pcma_ecb_show_receivers_list', function() {
            if(!Object.keys(receivers_obj).length) {
                return false;    
            }
            
            let contents = `
            <table class="widefat striped pcma_ecb_show_receivers_list_table">
                <thead>
                    <tr>
                        <th><strong>ID</strong></th>
                        <th><strong><?php _e('Username', PC_ML) ?></strong></th>
                        <th><strong><?php _e('E-mail', PC_ML) ?></strong> <span class="pc_del_field dashicons dashicons-no-alt" onclick="window.lcwpm_close()"></span></th>
                    </tr>
                </thead>
                <tbody>
            `;
            
            
            $.each(receivers_obj, function(i, data) {
                
                contents += `
                <tr>
                    <th>${ data.id }</th>
                    <th>${ data.username }</th>
                    <th>${ data.email }</th>
                </tr>`;
            });
            
            
            contents += `
                </tbody>
            </table>`;
            
            lc_wp_popup_message('modal', contents);
            $('.lcwpm_modal').addClass('pcma_ecb_rlt_modal');
        });
        
        
    })(jQuery);
    </script>    
    <?php
}





// attachments
function pcma_ecb_attachments() {
    global $post;
    $attachments = get_post_meta($post->ID, 'pcma_ecb_attach', true); // commma split list of WP media file IDs   
    
    ?>
    <input type="hidden" name="pcma_ecb_attach" id="pcma_ecb_attach" value="<?php echo esc_attr($attachments) ?>" autocomplete="off" />
                
    <ul class="pcma_ecb_attach_list" data-no-attach="<?php esc_attr_e('no attachments', PCMA_ML) ?>" style="--spinner: url('<?php echo site_url('/wp-admin/images/spinner-2x.gif') ?>')"><?php

        // NB: print in ASC order to allow easier JS operations - they will be reversed via CSS    
        $attachments = (empty($attachments)) ? array() : explode(',', $attachments);
        asort($attachments);    

        foreach((array)$attachments as $file_id) {
            echo pcma_email_campaigns::admin_builder_attach_code($file_id, $post->ID);
        }
    ?></ul>


    <script type="text/javascript">
    (function($) { 
        "use strict";    

        window.pcma_ecb_nonce = '<?php echo wp_create_nonce('lcwp_nonce') ?>',
        window.pcma_ecb_campaign_id = <?php echo $post->ID; ?>,
        window.pcma_ecb_can_be_edited = <?php echo (pcma_email_campaigns::campaign_can_be_edited($post->ID, $post->status)) ? 'true' : 'false' ?>;

        
        // can't be edited? remove add btn
        if(!window.pcma_ecb_can_be_edited) {
            $('.pcma_ecb_add_attach_btn').remove();  
            $('.pcma_ecb_set_current_datetime').remove();
        }
        
        
        // force metabox to be shown
        const force_expanded_attach_metabox = function() {
            setTimeout(function() {
                if($('#pcma_ecb_attachments.closed').length) {
                    $('#pcma_ecb_attachments .handlediv').trigger('click');
                }
            }, 50);            
        };
        $(document).ready(function() {
            force_expanded_attach_metabox();        
        });
        
        
        
        // add attachments - wp lightbox
        let wp_media_frame = false;

        $(document).on('click', '.pcma_ecb_add_attach_btn', function(e) {
            let already_chosen = ($('#pcma_ecb_attach').val()) ? desc_array_val_sort($('#pcma_ecb_attach').val().split(',')) : [];

            // metabox must be shown
            force_expanded_attach_metabox();
            
            // If the media frame already exists, reopen it.
            if(wp_media_frame){
                wp_media_frame.open();
                return;
            }


            // Create the media frame
            wp_media_frame = wp.media.frames.wp_media_frame = wp.media({
                title: "Mail Actions add-on - <?php esc_attr_e('attachments selection', PCMA_ML) ?>",
                button: {
                    text: "<?php esc_attr_e('Select') ?>",
                },
                //library : {type : 'image'},
                multiple: true
            });


            // are there selected files?
            wp_media_frame.on('open', function() {
                if(already_chosen) {
                    let selection = wp_media_frame.state().get('selection');

                    $.each(already_chosen, function(key, file_id) {
                        let attachment = wp.media.attachment(file_id);
                        attachment.fetch();

                        selection.add(attachment ? [attachment] : []);    
                    });
                }
            });


            // Selecting files
            wp_media_frame.on('select', function() {
                let cloned_selection = [...already_chosen];
                
                wp_media_frame.state().get('selection').map(function(data) {
                    data = data.toJSON();
                    
                    if(data.id) {
                        cloned_selection.push(data.id);    
                    }
                });
                
                cloned_selection = cloned_selection.filter((v, i, a) => a.indexOf(v) === i);
                cloned_selection = desc_array_val_sort(cloned_selection);
                
                // act only if there are differences
                const added_files = cloned_selection.filter(x => !already_chosen.includes(x));
                if(!added_files.length) {
                    return true;
                }

                already_chosen = [...cloned_selection];
                $('#pcma_ecb_attach').val( already_chosen.join(',') );
                
                $('.pcma_ecb_attach_list').addClass('pcma_ecb_attach_list_loading');
                $('.pcma_ecb_add_attach_btn').css('visibility', 'hidden');
                
                
                // to get consistent code - run through PHP
                let data = {
                    action      : 'pcma_ecb_new_attach_code',
                    new_files   : added_files,
                    campaign_id : window.pcma_ecb_campaign_id,
                    nonce       : window.pcma_ecb_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    try {
                        const resp = JSON.parse(response);

                        if(resp.status != 'success') {
                            lc_wp_popup_message('error', resp.mess);	
                            return false;
                        }
                        
                        // insert in right order (ASC, then reversed via CSS)
                        $.each(resp.codes, function(file_id, code) {
                             
                            let printed = false;
                            $('.pcma_ecb_attach_list > li').each(function() {
                                const target_file_id = parseInt($(this).data('file-id'), 10);

                                if(parseInt(file_id, 10) < target_file_id) {
                                    $(this).before(code);
                                    printed = true;
                                    return false;
                                }
                            });

                            // not printed - append
                            if(!printed) {
                                $('.pcma_ecb_attach_list').append(code); 
                            }
                        });
                    }
                    catch(e) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e('Error getting attachments code', PCMA_ML) ?>");

                        $('.pcma_ecb_attach_list').removeClass('pcma_ecb_attach_list_loading');
                        $('.pcma_ecb_add_attach_btn').css('visibility', 'visible');
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e('Error getting attachments code', PCMA_ML) ?>");	
                    }    
                })
                .always(function() {
                    $('.pcma_ecb_attach_list').removeClass('pcma_ecb_attach_list_loading');
                    $('.pcma_ecb_add_attach_btn').css('visibility', 'visible');
                });
                
                
            });

            wp_media_frame.open();
        });
        
        
        
        // correct number sort in descending order
        const desc_array_val_sort = function(array) {
            array.sort(function(a, b) {
              return a - b;
            }); 
            
            return array.reverse();
        };
        
        
        
        // remove attachment 
        if(window.pcma_ecb_can_be_edited) {
            $(document).on('click', '.pcma_ecb_attach_list .dashicons-no-alt', function() {
                $(this).parents('li').first().remove();
            });
        }
        
    })(jQuery);
    </script>
    <?php
}





// receivers
function pcma_ecb_receivers() {
    global $post, $pc_users;
    
    $can_be_edited = pcma_email_campaigns::campaign_can_be_edited($post->ID, $post->status);
    $disabled = ($can_be_edited) ? '' : 'disabled'; 
    
    include_once(PC_DIR .'/classes/pc_form_framework.php');
    $f_fw = new pc_form;
    
    
    $keys = array(
        'pcma_ecb_include_pc_cats',
        'pcma_ecb_exclude_pc_cats',
        'pcma_ecb_incl_disabled_users',
        'pcma_ecb_auf_operator',
        'pcma_ecb_user_filters',
        'pcma_ecb_extra_user_ids',
        'pcma_ecb_extra_emails',
    );
    $metas = array();
    
    foreach($keys as $key) {
        $metas[$key] = get_post_meta($post->ID, $key, true);    
    }
    
    ?>
    <fieldset <?php echo $disabled ?>>
        <table class="widefat pcma_ecb_opts_table">
            <tr>
                <td><?php _e('Targeted user categories?', PCMA_ML); ?></td>
                <td>
                    <select name="pcma_ecb_include_pc_cats[]" multiple="multiple" class="pcma_lc_select" data-placeholder="<?php esc_attr_e('Select categories', PCMA_ML) ?> .." autocomplete="off" <?php echo $disabled ?>>   
                        <?php
                        // inject bulk selection
                        $opts = pc_static::user_cat_dd_opts($metas['pcma_ecb_include_pc_cats'], false, true);
    
                        $ti_sel = (in_array('all', (array)$metas['pcma_ecb_include_pc_cats'])) ? 'selected="selected"' : '';
                        $to_inject = (pc_wpuc_static::get_wp_user_editable_pc_cats() == 'any') ? '<option value="all" '. $ti_sel .' class="pc_all_field">'. esc_html__('Any user', PCMA_ML) .'</option>' : '';
    
                        echo $to_inject . $opts;
                        ?>
                    </select>    
                </td>
            </tr>

            <tr class="pcma_ecb_exclude_wrap <?php echo (empty($metas['pcma_ecb_include_pc_cats']) || (array)$metas['pcma_ecb_include_pc_cats'][0] == 'all') ? 'pc_displaynone' : '' ?>">
                <td><?php _e('Among them, exclude', PCMA_ML); ?></td>
                <td>
                    <select name="pcma_ecb_exclude_pc_cats[]" multiple="multiple" class="pcma_lc_select" data-placeholder="<?php esc_attr_e('Select categories', PCMA_ML) ?> .." autocomplete="off" <?php echo $disabled ?>>
                        <?php
                        echo pc_static::user_cat_dd_opts($metas['pcma_ecb_exclude_pc_cats'], false, true);
                        ?>
                    </select>    
                </td>
            </tr>

            <tr class="pcma_ecb_user_statuses <?php echo (empty($metas['pcma_ecb_include_pc_cats'])) ? 'pc_displaynone' : '' ?>">
                <td><?php _e('Include disabled users?', PCMA_ML); ?></td>
                <td>
                    <input type="checkbox" name="pcma_ecb_incl_disabled_users" value="1" <?php checked('1', $metas['pcma_ecb_incl_disabled_users']) ?> class="pcma_lc_switch" autocomplete="off" <?php echo $disabled ?> />
                </td>
            </tr>

            <?php
            // PCMA-ACTION - allow extra fields to be printed in the Campaigns builder receivers area. Passes $post object and stored PCMA metas
            do_action('pcma_ecb_extra_fields', $post, $metas, $can_be_edited);
            ?>
            
            <tr class="pcma_ecb_user_filters <?php echo (empty($metas['pcma_ecb_include_pc_cats'])) ? 'pc_displaynone' : '' ?>">
                <td><?php _e('Additional filters', PCMA_ML); ?></td>
                <td>
                    <div class="pcma_ecb_auf_wrap">
                        <select name="pcma_ecb_u_filter_f" class="pcma_lc_select" autocomplete="off" <?php echo $disabled ?>>
                            <?php
                            foreach($f_fw->fields as $f_id => $f_data) { 
                                if(in_array($f_id, array('psw', 'pc_disclaimer', 'categories', 'pcpp_plan'))) { // TODO - maybe pass through a WP filter in future?
                                    continue;    
                                }
                                echo '<option value="'. esc_attr($f_id) .'">'. esc_html($f_data['label']) .'</option>';    
                            }
                            ?>
                        </select>

                        <input type="button" value="<?php esc_attr_e("Add condition", PCMA_ML) ?>" class="button-secondary" />
                    </div>    

                    <ul id="pcma_ecb_auf_list"><?php       
                        if(!empty($metas['pcma_ecb_user_filters'])) {
                            foreach($metas['pcma_ecb_user_filters'] as $filter_data) {
                                echo pcma_email_campaigns::admin_builder_user_filter_code($filter_data, $f_fw->fields);
                            }
                        }
                    ?></ul>  

                    <div id="pcma_ecb_auf_operator_wrap" class="<?php if(count((array)$metas['pcma_ecb_user_filters']) < 2) echo 'pc_displaynone' ?>">
                        <select name="pcma_ecb_auf_operator" autocomplete="off" class="pcma_lc_select">
                            <option value="OR"><?php esc_html_e('At least one condition must match', PCMA_ML) ?></option>
                            <option value="AND" <?php selected("AND", $metas['pcma_ecb_auf_operator']) ?>><?php esc_html_e('Every condition must match', PCMA_ML) ?></option>
                        </select>
                    </div>
                </td>
            </tr>

            <tr>
                <td colspan="2"></td>
            </tr>

            <tr class="pcma_ecb_single_users_wrap <?php echo ((array)$metas['pcma_ecb_include_pc_cats'][0] == 'all') ? 'pc_displaynone' : '' ?>">
                <td><?php _e('Add single users?', PCMA_ML); ?></td>
                <td>
                    <?php if($can_be_edited) : ?>
                        <input type="text" name="pcma_ecb_eui_search" placeholder="🔎 <?php esc_attr_e("search by e-mail, username, name or surname", PCMA_ML) ?>" autocomplete="off" />
                    <?php endif; ?>

                    <ul id="pcma_ecb_eui_list"><?php
                            if(!empty($metas['pcma_ecb_extra_user_ids'])) {
                                $args = array(
                                    'limit'     => -1,
                                    'user_id'   => $metas['pcma_ecb_extra_user_ids'],
                                    'to_get'    => array('id', 'name', 'surname', 'username', 'email'),
                                );

                                foreach($pc_users->get_users($args) as $ud) {
                                    $nicename = (!empty($ud['name']) && !empty($ud['surname'])) ? trim($ud['name'].' '.$ud['surname']).' ('.$ud['username'].' - '.$ud['email'].')' : $ud['username'] .' - '.$ud['email'];

                                    echo ' 
                                    <li data-uid="'. $ud['id'] .'">
                                        <div>
                                            <input type="hidden" name="pcma_ecb_extra_user_ids[]" value="'. $ud['id'] .'" />
                                            <span class="pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('remove user', PCMA_ML) .'"></span>
                                            '. $nicename .'
                                        </div>    
                                    </li>';
                                }
                            }
                        ?></ul>
                </td>
            </tr>

            <tr>
                <td><?php _e('Add extra receivers?', PCMA_ML); ?><br/>(<strong><?php _e('one e-mail per line', PCMA_ML); ?></strong>)</td>
                <td>
                    <textarea name="pcma_ecb_extra_emails" autocomplete="off" onkeyup="pcma_ecb_textAreaAdjust(this)"  <?php echo $disabled ?>><?php echo esc_textarea((string)$metas['pcma_ecb_extra_emails']) ?></textarea>
                    <small class="pcma_ecb_extra_emails_note"><?php _e("<strong>NB:</strong> obviously user-data placeholders and shortcodes can't work with direct e-mails usage", PCMA_ML) ?></small>
                </td>
            </tr>
        </table>
    </fieldset>    


    <?php
    // eventually block "pvtContent admin" user trying to manage campaigns targeting user categories not belonging to them 
    $block_pc_admin_user = false;
    foreach(pc_wpuc_static::get_wp_user_prevented_pc_cats() as $prev_cat_id) {
        if(in_array($prev_cat_id, (array)$metas['pcma_ecb_include_pc_cats'])) {

            $block_pc_admin_user = true;
            break;
        }
    }
    ?>

    <script type="text/javascript">
    (function($) { 
        "use strict";

        <?php if($block_pc_admin_user) : ?>
        window.location.href = `<?php echo admin_url('edit.php?post_type=pcma_email_campaigns') ?>`;
        return false;
        <?php endif; ?>
        
        
        // exclude field on include change and manage include selection for the "all" case
        $(document).on("change", "select[name='pcma_ecb_include_pc_cats[]']", function() {
            let val = ($(this).val() !== null && typeof($(this).val()) == "object") ? $(this).val() : [];

            // if ALL is selected, discard the rest
            if($.inArray("all", val) !== -1) {
                $(this).find("option").prop("selected", false);
                $(this).find(".pc_all_field").prop("selected", true);

                val = ["all"];

                const resyncEvent = new Event("lc-select-refresh");
                this.dispatchEvent(resyncEvent);
            }
            
            // hook for third-part codes
            $(document).trigger('pcma_ecb_include_pc_cats_updated', [val]);
            
            if(!val.length || $.inArray("all", val) !== -1) {
                $('.pcma_ecb_exclude_wrap').addClass('pc_displaynone');
            } 
            else {
                $('.pcma_ecb_exclude_wrap').removeClass('pc_displaynone');    
            }
            
            if(!val.length) {
                $('.pcma_ecb_user_filters, .pcma_ecb_user_statuses').addClass('pc_displaynone');
            } else {
                $('.pcma_ecb_user_filters, .pcma_ecb_user_statuses').removeClass('pc_displaynone');    
            }
            
            if($.inArray("all", val) !== -1) {
                $('.pcma_ecb_single_users_wrap').addClass('pc_displaynone');
            } else {
                $('.pcma_ecb_single_users_wrap').removeClass('pc_displaynone');    
            }
        }); 
        
        
        
        // add user filters
        $(document).on('click', '.pcma_ecb_auf_wrap .button-secondary', function() {
            
            const field = $('.pcma_ecb_auf_wrap select').val(),
                  label = $('.pcma_ecb_auf_wrap option[value="'+ field +'"]').text();
            
            let filter_code = `<?php echo pcma_email_campaigns::admin_builder_user_filter_code() ?>`;
            
            if($('.pcma_ecb_user_filters input[type="hidden"][value="'+ field +'"]').length) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Field already among filters', PCMA_ML) ?>");
                return false;
            }
            
            $('#pcma_ecb_auf_list').append( filter_code.replace('%%FIELD%%', field).replace('%%LABEL%%', label) );
            
            if($('#pcma_ecb_auf_list li').length >= 2) {
                $('#pcma_ecb_auf_operator_wrap').removeClass('pc_displaynone');
            }
        });
        
        
        
        // remove user filters
        $(document).on('click', '#pcma_ecb_auf_list .pc_del_field', function() {
            $(this).parents('li').first().remove();
            
            if($('#pcma_ecb_auf_list li').length < 2) {
                $('#pcma_ecb_auf_operator_wrap').addClass('pc_displaynone');        
            }
        });
        
        
        
        
        $(document).ready(function($) {

            // single user - autocomplete + ajax search
            $("input[name=pcma_ecb_eui_search]").autocomplete({
                source: function(request, response) {

                    let to_exclude = [];
                    $('#pcma_ecb_eui_list li').each(function() {
                        to_exclude.push( parseInt($(this).data('uid'), 10) );        
                    });

                    let data = {
                        action     : 'pcma_ecb_users_search',
                        search     : request.term,
                        to_exclude : to_exclude,
                        nonce      : window.pcma_ecb_nonce
                    };
                    $.post(ajaxurl, data, function(resp) {
                        response( $.parseJSON(resp) );
                    });	
                },
                minLength: 3,
                select: function(event, ui) {

                    if(!ui.item.id) {
                        return false;    
                    }

                    // check already selected users
                    if($('#pcma_ecb_eui_list li[data-uid='+ ui.item.id +']').length) {
                        lc_wp_popup_message('error', "<?php esc_attr_e('User already selected', PCMA_ML) ?>");	
                    }
                    else {
                        $('#pcma_ecb_eui_list').append(
                            `<li data-uid="${ ui.item.id }">
                                <div>
                                    <input type="hidden" name="pcma_ecb_extra_user_ids[]" value="${ ui.item.id }" />
                                    <span class="pc_del_field dashicons dashicons-no-alt" title="<?php esc_attr_e('remove user', PCMA_ML) ?>"></span>
                                    ${ ui.item.label }
                                </div>
                            </li>`
                        );
                    }

                    $(this).val(''); 
                    return false;
                },
                open: function() {
                    $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
                },
                close: function() {
                    $(this).removeClass( "ui-corner-top" ).addClass("ui-corner-all");
                }
            });


            
            // remove single user
            $(document).on('click', '#pcma_ecb_eui_list .pc_del_field', function() {
                $(this).parents('li').first().remove();
            });
            
            
            
            //////////////////////////////////////////////////////////


            
            // be sure data is okay to submit the form
            const abort_post_save = function(error_message) {
                $('#publishing-action .spinner, #save-action .spinner').removeClass('is-active');
                $('#publish, #save-post').removeClass('disabled');
                
                lc_wp_popup_message('error', error_message);
                return false;
            };
            
            $(document).on('submit', '#post', function(e) {

                // be sure it is correctly scheduled in the future
                let now = new Date().toLocaleString("en-US", {timeZone: "<?php echo wp_timezone_string() ?>"});
                now = new Date(now);
                
                const scheduled = new Date( $('[name="pcma_ecb_date"]').val() +' '+ $('[name="hh"]').val() +':'+ $('[name="mn"]').val() +':00');
                
                if(scheduled.getTime() < now.getTime()) {
                    return abort_post_save("<?php esc_attr_e('Please schedule the campaign in a future date', PCMA_ML) ?>");
                }


                // title and contents must be in!
                const editor_mode = ($('#wp-content-wrap').hasClass('tmce-active')) ? 'mce' : 'text',
                      contents = (editor_mode == 'mce') ? tinyMCE.activeEditor.getContent() : $('textarea.wp-editor-area').val().trim();
                
                
                if(!$('input[name="pcma_ecb_title"]').val().trim() || !contents) {
                    return abort_post_save("<?php esc_attr_e('Missing title or contents', PCMA_ML) ?>");
                }

                // be sure at least one receiver is set
                if(!$('select[name="pcma_ecb_include_pc_cats[]"]').val().length && !$('input[name="pcma_ecb_extra_user_ids[]"]').length && !$('textarea[name="pcma_ecb_extra_emails"]').val().trim()) {
                    
                    return abort_post_save("<?php esc_attr_e('Please insert the campaign receivers', PCMA_ML) ?>");        
                }
            });
            
            

            //////////////////////////////////////////////////////////


            
            // LC select
            new lc_select('.pcma_lc_select', {
                wrap_width : '100%',
                addit_classes : ['lcslt-lcwp'],
            });
            
            // LC Switch
            lc_switch('.pcma_lc_switch', {
                on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
                off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
            });
            
        }); // doc ready

        
        
        // auto-height textarea
        window.pcma_ecb_textAreaAdjust = function(o) {
            o.style.height = "1px";
            o.style.height = (4 + o.scrollHeight)+"px";
        };
        
        
          
        //////////////////////////////////////////////////////////



        <?php
        // extra operations if can't edit cmp
        if(!$can_be_edited) :                
        ?>
        document.body.classList.add('pcma_cmp_locked');
        
        if(document.querySelector('#pcma_email_cmp_cats-adder')) {
            document.querySelector('#pcma_email_cmp_cats-adder').remove();    
        }
        
        document.querySelectorAll('#pcma_email_cmp_catsdiv input').forEach(function($f) {
            $f.disabled = true;    
        });
        <?php endif; ?>
        
        
    })(jQuery);
    </script>
    <?php
}






///////////////////////////////////
//  BE SURE ALL DATA IS FILLED

function pcma_ecb_meta_save() {
    global $post;

    if(!is_object($post) || $post->post_type != 'pcma_email_campaigns') {
        return false;    
    }
    if(isset($_GET['action']) && in_array($_GET['action'], array('trash', 'untrash', 'delete'))) {
        return false;    
    }
    
    include_once(PC_DIR .'/classes/simple_form_validator.php');
    $validator = new simple_fv;
     
    $indexes = array();
    $indexes[] = array('index'=>'pcma_ecb_title', 'label'=>'E-mail title');
    $indexes[] = array('index'=>'pcma_ecb_template', 'label'=>'E-mail template');
    $indexes[] = array('index'=>'pcma_ecb_attach', 'label'=>'Attachments');
    
    // maybe specify which user categories can be involved
    if(pc_wpuc_static::get_wp_user_editable_pc_cats() == 'any') {
        $indexes[] = array('index'=>'pcma_ecb_include_pc_cats', 'label'=>'Targeted user categories');
        $indexes[] = array('index'=>'pcma_ecb_exclude_pc_cats', 'label'=>'Excluded user categories');
    } else {
        $indexes[] = array('index'=>'pcma_ecb_include_pc_cats', 'label'=>'Targeted user categories', 'allowed' => pc_wpuc_static::get_wp_user_editable_pc_cats());
        $indexes[] = array('index'=>'pcma_ecb_exclude_pc_cats', 'label'=>'Excluded user categories', 'allowed' => pc_wpuc_static::get_wp_user_editable_pc_cats());        
    }
    
    $indexes[] = array('index'=>'pcma_ecb_incl_disabled_users', 'label'=>'Include disabled users?');
    $indexes[] = array('index'=>'pcma_ecb_auf_f', 'label'=>'User filters - fields');
    $indexes[] = array('index'=>'pcma_ecb_auf_cond', 'label'=>'User filters - conditions');
    $indexes[] = array('index'=>'pcma_ecb_auf_val', 'label'=>'User filters - values');
    $indexes[] = array('index'=>'pcma_ecb_auf_operator', 'label'=>'User filters - operator');
    
    $indexes[] = array('index'=>'pcma_ecb_extra_user_ids', 'label'=>'Extra user IDs');
    $indexes[] = array('index'=>'pcma_ecb_extra_emails', 'label'=>'Extra e-mails');
    
    $validator->formHandle($indexes);
    $fdata = $validator->form_val;
    $error = $validator->getErrors();

    
    // be sure it is correctly scheduled in future 
    $schedule_date = $_POST['pcma_ecb_date'] .' '. $_POST['hh'] .':'. $_POST['mn'] .':00';
    if(!$error && strtotime($schedule_date) < (int)current_time('timestamp') ) {
        $error = __('Please schedule the campaign in a future date', PCMA_ML); 
    }

    
    // title and contents must be in!
    if(!$error && (empty($fdata['pcma_ecb_title']) || empty($_POST['content'])) ) {
        $error = __('Missing title or contents', PCMA_ML);        
    }
    
    
    // if extra mails - be sure all are valid
    if(!$error && !empty($fdata['pcma_ecb_extra_emails'])) {
        $extra_mails_array = pcma_email_campaigns::extra_emails_val_to_array($fdata['pcma_ecb_extra_emails']);
        
        $em_errors = array();
        foreach($extra_mails_array as $key => $em) {
            if(!filter_var($em, FILTER_VALIDATE_EMAIL)) {
                $em_errors[] = (empty($em)) ? '<em>'. __('empty string', PCMA_ML) .'</em>' : $em;
                unset($extra_mails_array[$key]);
            }
        }
        
        if(!empty($em_errors)) {
            $error = __('Please insert valid e-mail addresses (one per row) in the "Extra receivers" field (wrong ones:', PCMA_ML) .' '. implode(', ', $em_errors) .')'; 
        }
    }
    
    // be sure at least one receiver is set
    if(!$error && empty($fdata['pcma_ecb_include_pc_cats']) && empty($fdata['pcma_ecb_extra_user_ids']) && empty($fdata['pcma_ecb_extra_emails'])) {
        $error = __('Please insert the campaign receivers', PCMA_ML);         
    }
        
    
    // are there user categories? check for filters and eventually prepare the array
    $fdata['pcma_ecb_user_filters'] = array();
    
    if(!$error && !empty($fdata['pcma_ecb_include_pc_cats']) && !empty($fdata['pcma_ecb_auf_f'])) {
        if(count((array)$fdata['pcma_ecb_auf_f']) != count((array)$fdata['pcma_ecb_auf_cond']) || count((array)$fdata['pcma_ecb_auf_f']) != count((array)$fdata['pcma_ecb_auf_val'])) {
            $error = 'User filters - elements do not have the same number of values';        
        }
        
        else {
            for($a=0; $a < count((array)$fdata['pcma_ecb_auf_f']); $a++) {
                
                $fdata['pcma_ecb_user_filters'][] = array(
                    'field' => (string)$fdata['pcma_ecb_auf_f'][$a],
                    'cond'  => (string)$fdata['pcma_ecb_auf_cond'][$a],
                    'val'   => (string)$fdata['pcma_ecb_auf_val'][$a],
                ); 
            }
        }
    }
    
    // clean useless filter indexes
    unset($fdata['pcma_ecb_auf_f']);
    unset($fdata['pcma_ecb_auf_cond']);
    unset($fdata['pcma_ecb_auf_val']);

    
    // PCMA-FILTER - manage fields val array passed to count involved campaign users - fields can be fetched through $_POST
    $fdata = apply_filters('pcma_filter_ecb_meta_save', $fdata);
    
    // clean and save
    if(empty($error)) {
        foreach($fdata as $key=>$val) {
            if(!is_array($val)) {
                $fdata[$key] = stripslashes($val);
            }
            else {
                $fdata[$key] = array();
                foreach($val as $arr_val) {
                    $fdata[$key][] = (is_array($arr_val) || is_object($arr_val)) ? $arr_val : stripslashes($arr_val);
                }
            }
        }

        // save data
        foreach($fdata as $key=>$val) {
            
            // compress e-mails list
            if($key == 'pcma_ecb_extra_emails') {
                $val = pc_static::compress_data($val);    
            }
            
            update_post_meta($post->ID, $key, $fdata[$key]); 
        }
        
        
        // has been edited - reset stats
        $stats_metas = array('pcma_ecb_fdata_error', 'pcma_ecb_receivers', 'pcma_ecb_start_time', 'pcma_ecb_receivers_processed', 'pcma_ecb_receivers_failed');
        foreach($stats_metas as $sm) {
            delete_post_meta($post->ID, $sm);
        }
    }
    
    // show error
    else {
        update_post_meta($post->ID, 'pcma_ecb_fdata_error', $error);

        wp_die(
            '<img src="'. esc_attr(site_url('/wp-admin/images/spinner-2x.gif')) .'" />
            <script type="text/javascript">
            (function($) { 
                "use strict";

                document.querySelector(".wp-die-message").style.textAlign = "center";
                window.location.href = `'. admin_url('post.php?post='. $post->ID .'&action=edit') .'`
            })();
            </script>'
        );
    }
}
add_action('pre_post_update', 'pcma_ecb_meta_save', 1);



// show validation error and clean
function pcma_ecb_validation_errors() {
    global $current_screen, $post;
    
    if($current_screen->id == "pcma_email_campaigns" && is_object($post)) {
        $errors = get_post_meta($post->ID, 'pcma_ecb_fdata_error', true);
        
        if(!empty($errors)) {
            echo '<div class="error"><p>'. $errors .'</p></div>';
            delete_post_meta($post->ID, 'pcma_ecb_fdata_error');
        }
    }
}
add_action('admin_notices', 'pcma_ecb_validation_errors');






// if can't edit but somehow the action has been triggered - set to draft
function pcma_ecb_force_status($data, $postarr) {
    if($data['post_type'] == 'pcma_email_campaigns' && !pcma_email_campaigns::campaign_can_be_edited($postarr['ID'], $data['post_status'])) {
        $data['post_status'] = 'draft';     
    }
    return $data;
}
add_filter('wp_insert_post_data', 'pcma_ecb_force_status', 99999, 2);
